/**********************************************************************************/
/*    Test program for:															  */
/*	  Board: AVR-PX128A1														  */
/*    Manufacture: OLIMEX                                                   	  */
/*	  COPYRIGHT (C) 2008														  */
/*    Designed by: Engineer Penko T. Bozhkov                                      */
/*    Module Name    :  GDSC-0801WP-01-MENT                                       */
/*    File   Name    :  lcd.h                                                     */
/*    Revision       :  Rev.B                                                     */
/*    Date           :  20.03.2009					                              */
/**********************************************************************************/
#ifndef __LCD_GDSC_0801WP_01_H
#define __LCD_GDSC_0801WP_01_H

/****** 1.All functions prototypes *****/
void wait(volatile unsigned long delay);
void LCD_Clear(void);
void LCD_SEND_CHR(unsigned char character);
void LCD_SEND_CMD(unsigned char command);
void LCD_Send_Symbol(unsigned char row, unsigned char position, unsigned char *symbol);
void LCD_Send_STR(unsigned char row, char *dataPtr);
void LCD_Send_Long_STR(unsigned char row, unsigned long shift_rate, char *dataPtr);
void LCD_Check_Busy_Flag(void);
void LCD_Read_Symbol(unsigned char row, unsigned char position);
void LCD_Init(void);


/****** 2.All definitions *****/
#define	RS_ON				PORTC.OUT |= 0x02;
#define	RS_OFF				PORTC.OUT &= ~0x02;
#define	RW_ON				PORTC.OUT |= 0x04;
#define	RW_OFF				PORTC.OUT &= ~0x04;
#define	EN_ON				PORTC.OUT |= 0x08;
#define	EN_OFF				PORTC.OUT &= ~0x08;
#define LCD_write_reg       PORTE.OUT = LCD_write;
#define LCD_read_reg        LCD_read = PORTE.IN;
// Related with buttons
#define BUT1_On_flag				flag_register |= 0x80;
#define	BUT1_Off_flag				flag_register &= ~0x80;
#define	BUT1_On_Check				(flag_register & 0x80)
#define BUT2_On_flag				flag_register |= 0x08;
#define	BUT2_Off_flag				flag_register &= ~0x08;
#define	BUT2_On_Check				(flag_register & 0x08)

extern volatile unsigned char	flag_register;

#endif //__LCD_GDSC_0801WP_01_H
